Feature: Exercise and validate V functionality

Background: Load Command Module
  Given Load the Command Mod
  Then Init the Command Mod
  Then I set the path to V as "/home/mod6"
  Then I set the home directory

@0 @noFlagsFirstRun
Scenario: User executes V without any flags on first run
  Then validate V output without any flags on first run

@1 @mirrorsFlag
Scenario: User checks the mirrors file and sig from thebitcoin.foundation website
  Then validate mirrors "http://thebitcoin.foundation" and sigs from "mod6" 

@2 @initFlag
Scenario: User executes V with the init flag
  Then validate init "i http://thebitcoin.foundation" short flag output
  Then validate init "i" without option argument

@3 @initFlag
Scenario: User executes V with the init flag again - Negative Test
  Then validate init "init http://thebitcoin.foundation" long flag output
  Then validate init "init" without option argument

@4 @initFlag
Scenario: User executes V with the init flag with user specified directories
  Then validate init "i" with URL "http://thebitcoin.foundation" with patchdir "vpatch" and sealdir "seals"
  Then I remove "vpatch"
  Then I remove "seals"

@5 @flagsRequireArgs
Scenario: User exectes V each option without an argument
  Then validate option "m" without an argument
  Then validate option "mirrors" without an argument
  Then validate option "i" without an argument
  Then validate option "init" without an argument
  Then validate option "wd" without an argument
  Then validate option "wotdir" without an argument
  Then validate option "pd" without an argument
  Then validate option "patchdir" without an argument
  Then validate option "sd" without an argument
  Then validate option "sealdir" without an argument
  Then validate option "p" without an argument
  Then validate option "press" without an argument
  Then validate option "ss" without an argument
  Then validate option "sync-seals" without an argument
  Then validate option "sv" without an argument
  Then validate option "sync-vpatches" without an argument
  Then validate option "sa" without an argument
  Then validate option "sync-all-vpatches" without an argument
  Then validate option "se" without an argument
  Then validate option "sync-everything" without an argument
  Then validate option "a" without an argument
  Then validate option "ante" without an argument
  Then validate option "antecedents" without an argument
  Then validate option "d" without an argument
  Then validate option "desc" without an argument
  Then validate option "descendants" without an argument
  Then validate option "g" without an argument
  Then validate option "graph" without an argument

@6 @flagsRequireNumberOfArgs 
Scenario: The user executes V with one less argument than required and validates output. Negative Test.
  Then validate option "p" with "1" argument
  Then validate option "press" with "1" argument
  Then validate option "ss" with "1" argument
  Then validate option "sync-seals" with "1" argument
  Then validate option "sv" with "2" argument
  Then validate option "sync-vpatches" with "2" argument
  Then validate option "sa" with "1" argument
  Then validate option "sync-all-vpatches" with "1" argument
  Then validate option "se" with "2" argument
  Then validate option "sync-everything" with "2" argument

@7 @helpFlag
Scenario: User executes V with the help flag
  Then validate help "h" flag output
  Then validate help "help" flag output
  Then validate help "?" flag output

@8 @helpMessage
Scenario: User inputs an unknown argument to V
  Then validate short help message

@9 @versionMessage
Scenario: User checks the version of V
  Then validate version message

@10 @wotFlag
Scenario: User executes V with the wot flag
  Then validate wot "w" flag output 
  Then validate wot "wot" flag output 

@11 @wotFlag
Scenario: User executes V with the wot flag with finger flag
  Then validate wot "w finger" flag output 
  Then validate wot "wot finger" flag output 

@12 @rootsFlag
Scenario: User executes V with the roots flag
  Then validate roots "r" flag output with signatories "asciilifeform, mircea_popescu, mod6, trinque"
  Then validate roots "roots" flag output with signatories "asciilifeform, mircea_popescu, mod6, trinque"

@13 @leafsFlag
Scenario: User executes V with the leafs flag
  Then validate leafs "l" flag output with signatories "asciilifeform"
  Then validate leafs "leafs" flag output with signatories "asciilifeform"

@14 @antecedentsFlag
Scenario: User executes V with the antecedents flag
  Then validate antecedents "a mod6_fix_dumpblock_params.vpatch" flag output
  Then validate antecedents "ante mod6_fix_dumpblock_params.vpatch" flag output
  Then validate antecedents "antecedents mod6_fix_dumpblock_params.vpatch" flag output
  Then validate antecedents "a" without option argument
  Then validate antecedents "ante" without option argument
  Then validate antecedents "antecedents" without option argument

@15 @antecedentsOutput
Scenario: Validate Antecedents for each vpatch
  Given vpatch to process
   | vpatch                                                                |
   | bitcoin-asciilifeform.1.vpatch                                        |
   | rm_rf_upnp.vpatch                                                     |
   | bitcoin-asciilifeform.2-https_snipsnip.vpatch                         |
   | bitcoin-asciilifeform.3-turdmeister-alert-snip.vpatch                 |
   | bitcoin-asciilifeform.4-goodbye-win32.vpatch                          |
   | asciilifeform_orphanage_thermonuke.vpatch                             |
   | asciilifeform_tx-orphanage_amputation.vpatch                          |
   | bitcoin-v0_5_3_1-static_makefile_v002.8.vpatch                        |
   | asciilifeform_dnsseed_snipsnip.vpatch                                 |
   | bitcoin-v0_5_3_1-rev_bump.7.vpatch                                    |
   | asciilifeform_zap_hardcoded_seeds.vpatch                              |
   | bitcoin-v0_5_3-db_config.6.vpatch                                     |
   | asciilifeform_zap_showmyip_crud.vpatch                                |
   | asciilifeform-kills-integer-retardation.vpatch                        |
   | asciilifeform_dns_thermonyukyoolar_kleansing.vpatch                   |
   | asciilifeform_and_now_we_have_block_dumper_corrected.vpatch           |
   | asciilifeform_ver_now_5_4_and_irc_is_gone_and_now_must_give_ip.vpatch |
   | mod6_fix_dumpblock_params.vpatch                                      |
   | asciilifeform_and_now_we_have_eatblock.vpatch                         |
   | asciilifeform_lets_lose_testnet.vpatch                                |
   | asciilifeform_add_verifyall_option.vpatch                             |
   | asciilifeform_maxint_locks_corrected.vpatch                           |
   | asciilifeform-programmable-versionstring.vpatch                       |
   | mod6_der_high_low_s.vpatch                                            |
   | asciilifeform_malleus_mikehearnificarum.vpatch                        |
  Given expected antecedents
   | antecedents                                                                                                                                                                                        |
   | genesis.vpatch                                                                                                                                                                                     |
   | bitcoin-asciilifeform.1.vpatch!genesis.vpatch                                                                                                                                                      |
   | bitcoin-asciilifeform.1.vpatch!rm_rf_upnp.vpatch                                                                                                                                                   |
   | rm_rf_upnp.vpatch                                                                                                                                                                                  |
   | bitcoin-asciilifeform.1.vpatch!bitcoin-asciilifeform.2-https_snipsnip.vpatch!bitcoin-asciilifeform.3-turdmeister-alert-snip.vpatch!genesis.vpatch!rm_rf_upnp.vpatch                                |
   | bitcoin-asciilifeform.3-turdmeister-alert-snip.vpatch                                                                                                                                              |
   | asciilifeform_orphanage_thermonuke.vpatch!bitcoin-asciilifeform.4-goodbye-win32.vpatch                                                                                                             |
   | bitcoin-asciilifeform.2-https_snipsnip.vpatch                                                                                                                                                      | 
   | bitcoin-asciilifeform.4-goodbye-win32.vpatch                                                                                                                                                       |
   | bitcoin-asciilifeform.4-goodbye-win32.vpatch                                                                                                                                                       |
   | asciilifeform_dnsseed_snipsnip.vpatch                                                                                                                                                              |
   | bitcoin-asciilifeform.4-goodbye-win32.vpatch                                                                                                                                                       |
   | asciilifeform_zap_hardcoded_seeds.vpatch                                                                                                                                                           |
   | bitcoin-asciilifeform.4-goodbye-win32.vpatch                                                                                                                                                       |
   | asciilifeform_dnsseed_snipsnip.vpatch!asciilifeform_zap_showmyip_crud.vpatch!bitcoin-asciilifeform.4-goodbye-win32.vpatch!genesis.vpatch                                                           |
   | asciilifeform-kills-integer-retardation.vpatch                                                                                                                                                     |
   | asciilifeform_dns_thermonyukyoolar_kleansing.vpatch!bitcoin-v0_5_3_1-rev_bump.7.vpatch!bitcoin-v0_5_3_1-static_makefile_v002.8.vpatch!genesis.vpatch                                               |
   | asciilifeform_and_now_we_have_block_dumper_corrected.vpatch                                                                                                                                        |
   | asciilifeform-kills-integer-retardation.vpatch!asciilifeform_ver_now_5_4_and_irc_is_gone_and_now_must_give_ip.vpatch!bitcoin-asciilifeform.4-goodbye-win32.vpatch!mod6_fix_dumpblock_params.vpatch |
   | asciilifeform_and_now_we_have_eatblock.vpatch!asciilifeform_dns_thermonyukyoolar_kleansing.vpatch!asciilifeform_tx-orphanage_amputation.vpatch!genesis.vpatch                                      |
   | asciilifeform_lets_lose_testnet.vpatch                                                                                                                                                             |
   | bitcoin-v0_5_3-db_config.6.vpatch                                                                                                                                                                  |
   | asciilifeform_add_verifyall_option.vpatch!asciilifeform_ver_now_5_4_and_irc_is_gone_and_now_must_give_ip.vpatch                                                                                    |
   | asciilifeform-programmable-versionstring.vpatch!genesis.vpatch                                                                                                                                     |
   | asciilifeform_add_verifyall_option.vpatch                                                                                                                                                          |
  Given expected signatures
   | signatures                                                                                                                   |
   | asciilifeform, mircea_popescu, mod6, trinque                                                                                 |
   | asciilifeform, mod6!asciilifeform, mircea_popescu, mod6, trinque                                                             |
   | asciilifeform, mod6!asciilifeform, mod6                                                                                      |
   | asciilifeform, mod6                                                                                                          |
   | asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mircea_popescu, mod6, trinque!asciilifeform, mod6 |
   | asciilifeform, mod6                                                                                                          |
   | asciilifeform, mod6!asciilifeform, mod6                                                                                      |
   | asciilifeform, mod6                                                                                                          |
   | asciilifeform, mod6                                                                                                          |
   | asciilifeform, mod6                                                                                                          |
   | asciilifeform, mod6                                                                                                          |
   | asciilifeform, mod6                                                                                                          |
   | asciilifeform, mod6                                                                                                          |
   | asciilifeform, mod6                                                                                                          |
   | asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mircea_popescu, mod6, trinque                     |
   | asciilifeform, mod6                                                                                                          |
   | asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mircea_popescu, mod6, trinque                     |
   | asciilifeform, mod6                                                                                                          |
   | asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6                                              |
   | asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mircea_popescu, mod6, trinque                     |
   | asciilifeform, mod6                                                                                                          |
   | asciilifeform, mod6                                                                                                          |
   | asciilifeform, mod6!asciilifeform, mod6                                                                                      |
   | asciilifeform!asciilifeform, mircea_popescu, mod6, trinque                                                                   |
   | asciilifeform, mod6!asciilifeform, mod6                                                                                      |
  Given expected source files
   | source_files                                                                                                                                                                                                                                                                                                                                                                             |
   | a/bitcoin/src/bitcoinrpc.cpp; a/bitcoin/src/db.cpp; a/bitcoin/src/headers.h; a/bitcoin/src/init.cpp; a/bitcoin/src/qtui.h; a/bitcoin/src/util.h; a/bitcoin/src/wallet.cpp                                                                                                                                                                                                                |
   | a/bitcoin/src/db.cpp; a/bitcoin/src/init.cpp!a/bitcoin/src/main.cpp; a/bitcoin/src/main.h; a/bitcoin/src/makefile.linux-mingw; a/bitcoin/src/makefile.unix; a/bitcoin/src/net.cpp                                                                                                                                                                                                        |
   | a/bitcoin/src/bitcoinrpc.cpp!a/bitcoin/src/init.cpp; a/bitcoin/src/makefile.linux-mingw; a/bitcoin/src/makefile.unix                                                                                                                                                                                                                                                                     |
   | a/bitcoin/src/main.cpp; a/bitcoin/src/main.h                                                                                                                                                                                                                                                                                                                                             |
   | a/bitcoin/src/headers.h; a/bitcoin/src/util.h!a/bitcoin/src/bitcoinrpc.cpp; a/bitcoin/src/init.cpp; a/bitcoin/src/makefile.linux-mingw!a/bitcoin/src/main.h!a/bitcoin/src/crypter.cpp; a/bitcoin/src/net.h; a/bitcoin/src/protocol.cpp; a/bitcoin/src/script.h; a/bitcoin/src/serialize.h; a/bitcoin/src/uint256.h; a/bitcoin/src/util.cpp!a/bitcoin/src/db.cpp; a/bitcoin/src/net.cpp   |
   | a/bitcoin/src/main.cpp                                                                                                                                                                                                                                                                                                                                                                   |
   | a/bitcoin/src/main.cpp!a/bitcoin/src/main.h                                                                                                                                                                                                                                                                                                                                              | 
   | a/bitcoin/src/makefile.unix                                                                                                                                                                                                                                                                                                                                                              |
   | a/bitcoin/src/init.cpp; a/bitcoin/src/net.cpp                                                                                                                                                                                                                                                                                                                                            |
   | a/bitcoin/src/serialize.h                                                                                                                                                                                                                                                                                                                                                                |
   | a/bitcoin/src/net.cpp                                                                                                                                                                                                                                                                                                                                                                    |
   | a/bitcoin/src/db.cpp                                                                                                                                                                                                                                                                                                                                                                     |
   | a/bitcoin/src/net.cpp                                                                                                                                                                                                                                                                                                                                                                    |
   | a/bitcoin/src/bitcoinrpc.cpp; a/bitcoin/src/util.h                                                                                                                                                                                                                                                                                                                                       |
   | a/bitcoin/src/init.cpp!a/bitcoin/src/net.cpp!a/bitcoin/src/net.h; a/bitcoin/src/protocol.cpp!a/bitcoin/src/irc.cpp; a/bitcoin/src/protocol.h                                                                                                                                                                                                                                             |
   | a/bitcoin/src/bitcoinrpc.cpp                                                                                                                                                                                                                                                                                                                                                             |
   | a/bitcoin/src/init.cpp; a/bitcoin/src/irc.cpp; a/bitcoin/src/net.cpp; a/bitcoin/src/net.h!a/bitcoin/src/serialize.h!a/bitcoin/src/makefile.unix!a/bitcoin/src/irc.h                                                                                                                                                                                                                      |
   | a/bitcoin/src/bitcoinrpc.cpp                                                                                                                                                                                                                                                                                                                                                             |
   | a/bitcoin/src/util.h!a/bitcoin/src/init.cpp!a/bitcoin/src/util.cpp!a/bitcoin/src/bitcoinrpc.cpp                                                                                                                                                                                                                                                                                          |
   | a/bitcoin/src/bitcoinrpc.cpp; a/bitcoin/src/init.cpp; a/bitcoin/src/util.cpp; a/bitcoin/src/util.h!a/bitcoin/src/protocol.h!a/bitcoin/src/main.cpp!a/bitcoin/src/base58.h; a/bitcoin/src/checkpoints.cpp                                                                                                                                                                                 |
   | a/bitcoin/src/init.cpp; a/bitcoin/src/main.cpp; a/bitcoin/src/util.cpp; a/bitcoin/src/util.h                                                                                                                                                                                                                                                                                             |
   | a/bitcoin/src/db.cpp                                                                                                                                                                                                                                                                                                                                                                     |
   | a/bitcoin/src/init.cpp; a/bitcoin/src/util.cpp; a/bitcoin/src/util.h!a/bitcoin/src/makefile.unix; a/bitcoin/src/net.h; a/bitcoin/src/serialize.h                                                                                                                                                                                                                                         |
   | a/bitcoin/src/init.cpp; a/bitcoin/src/util.cpp; a/bitcoin/src/util.h!a/bitcoin/src/key.h                                                                                                                                                                                                                                                                                                 |
   | a/bitcoin/src/main.cpp                                                                                                                                                                                                                                                                                                                                                                   |
  Then validate output antecedents

@16 @descendantsFlag
Scenario: User executes V with the descendants flag
  Then validate descendants "d mod6_fix_dumpblock_params.vpatch" flag output
  Then validate descendants "desc mod6_fix_dumpblock_params.vpatch" flag output
  Then validate descendants "descendants mod6_fix_dumpblock_params.vpatch" flag output
  Then validate descendants "d" without option argument
  Then validate descendants "desc" without option argument
  Then validate descendants "descendants" without option argument

@17 @descendantsOutput
Scenario: Validate Descendants for each vpatch
  Given vpatch to process
   | vpatch                                                                |
   | genesis.vpatch                                                        |
   | bitcoin-asciilifeform.1.vpatch                                        |
   | rm_rf_upnp.vpatch                                                     |
   | bitcoin-asciilifeform.2-https_snipsnip.vpatch                         |
   | bitcoin-asciilifeform.3-turdmeister-alert-snip.vpatch                 |
   | asciilifeform_orphanage_thermonuke.vpatch                             |
   | bitcoin-asciilifeform.4-goodbye-win32.vpatch                          |
   | asciilifeform_tx-orphanage_amputation.vpatch                          |
   | bitcoin-v0_5_3_1-static_makefile_v002.8.vpatch                        |
   | asciilifeform_dnsseed_snipsnip.vpatch                                 |
   | bitcoin-v0_5_3_1-rev_bump.7.vpatch                                    |
   | asciilifeform_zap_hardcoded_seeds.vpatch                              |
   | bitcoin-v0_5_3-db_config.6.vpatch                                     |
   | asciilifeform_zap_showmyip_crud.vpatch                                |
   | asciilifeform-kills-integer-retardation.vpatch                        |
   | asciilifeform_dns_thermonyukyoolar_kleansing.vpatch                   |
   | asciilifeform_and_now_we_have_block_dumper_corrected.vpatch           |
   | asciilifeform_ver_now_5_4_and_irc_is_gone_and_now_must_give_ip.vpatch |
   | mod6_fix_dumpblock_params.vpatch                                      |
   | asciilifeform_and_now_we_have_eatblock.vpatch                         |
   | asciilifeform_lets_lose_testnet.vpatch                                |
   | asciilifeform_add_verifyall_option.vpatch                             |
   | asciilifeform-programmable-versionstring.vpatch                       |
  Given expected descendants
   | descendants                                                                                                                                                                                                                                                                                              |
   | asciilifeform_dns_thermonyukyoolar_kleansing.vpatch!asciilifeform_lets_lose_testnet.vpatch!asciilifeform_ver_now_5_4_and_irc_is_gone_and_now_must_give_ip.vpatch!bitcoin-asciilifeform.1.vpatch!bitcoin-asciilifeform.4-goodbye-win32.vpatch!mod6_der_high_low_s.vpatch!rm_rf_upnp.vpatch                |
   | bitcoin-asciilifeform.2-https_snipsnip.vpatch!bitcoin-asciilifeform.4-goodbye-win32.vpatch!rm_rf_upnp.vpatch                                                                                                                                                                                             |
   | bitcoin-asciilifeform.2-https_snipsnip.vpatch!bitcoin-asciilifeform.3-turdmeister-alert-snip.vpatch!bitcoin-asciilifeform.4-goodbye-win32.vpatch                                                                                                                                                         |
   | bitcoin-asciilifeform.4-goodbye-win32.vpatch!bitcoin-v0_5_3_1-static_makefile_v002.8.vpatch                                                                                                                                                                                                              |
   | asciilifeform_orphanage_thermonuke.vpatch!bitcoin-asciilifeform.4-goodbye-win32.vpatch                                                                                                                                                                                                                   |
   | asciilifeform_tx-orphanage_amputation.vpatch                                                                                                                                                                                                                                                             |
   | asciilifeform-kills-integer-retardation.vpatch!asciilifeform_and_now_we_have_eatblock.vpatch!asciilifeform_dns_thermonyukyoolar_kleansing.vpatch!asciilifeform_dnsseed_snipsnip.vpatch!asciilifeform_tx-orphanage_amputation.vpatch!bitcoin-v0_5_3-db_config.6.vpatch!bitcoin-v0_5_3_1-rev_bump.7.vpatch |
   | asciilifeform_lets_lose_testnet.vpatch                                                                                                                                                                                                                                                                   |
   | asciilifeform_ver_now_5_4_and_irc_is_gone_and_now_must_give_ip.vpatch                                                                                                                                                                                                                                    |
   | asciilifeform_dns_thermonyukyoolar_kleansing.vpatch!asciilifeform_zap_hardcoded_seeds.vpatch                                                                                                                                                                                                             |
   | asciilifeform_ver_now_5_4_and_irc_is_gone_and_now_must_give_ip.vpatch                                                                                                                                                                                                                                    |
   | asciilifeform_zap_showmyip_crud.vpatch                                                                                                                                                                                                                                                                   |
   | asciilifeform_maxint_locks_corrected.vpatch                                                                                                                                                                                                                                                              |
   | asciilifeform_dns_thermonyukyoolar_kleansing.vpatch                                                                                                                                                                                                                                                      |
   | asciilifeform_and_now_we_have_block_dumper_corrected.vpatch!asciilifeform_and_now_we_have_eatblock.vpatch                                                                                                                                                                                                |
   | asciilifeform_lets_lose_testnet.vpatch!asciilifeform_ver_now_5_4_and_irc_is_gone_and_now_must_give_ip.vpatch                                                                                                                                                                                             |
   | mod6_fix_dumpblock_params.vpatch                                                                                                                                                                                                                                                                         |
   | asciilifeform-programmable-versionstring.vpatch!asciilifeform_and_now_we_have_eatblock.vpatch                                                                                                                                                                                                            |
   | asciilifeform_and_now_we_have_eatblock.vpatch                                                                                                                                                                                                                                                            |
   | asciilifeform_lets_lose_testnet.vpatch                                                                                                                                                                                                                                                                   |
   | asciilifeform_add_verifyall_option.vpatch                                                                                                                                                                                                                                                                |
   | asciilifeform-programmable-versionstring.vpatch!asciilifeform_malleus_mikehearnificarum.vpatch                                                                                                                                                                                                           |
   | mod6_der_high_low_s.vpatch                                                                                                                                                                                                                                                                               |
  Given expected signatures
   | signatures                                                                                                                                  |
   | asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6!mod6!asciilifeform, mod6                |
   | asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6                                                                                 |
   | asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6                                                                                 |
   | asciilifeform, mod6!asciilifeform, mod6                                                                                                     |
   | asciilifeform, mod6!asciilifeform, mod6                                                                                                     |
   | asciilifeform, mod6                                                                                                                         |
   | asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6!asciilifeform, mod6 |
   | asciilifeform, mod6                                                                                                                         |
   | asciilifeform, mod6                                                                                                                         |
   | asciilifeform, mod6!asciilifeform, mod6                                                                                                     |
   | asciilifeform, mod6                                                                                                                         |
   | asciilifeform, mod6                                                                                                                         |
   | asciilifeform, mod6                                                                                                                         |
   | asciilifeform, mod6                                                                                                                         |
   | asciilifeform, mod6!asciilifeform, mod6                                                                                                     |
   | asciilifeform, mod6!asciilifeform, mod6                                                                                                     |
   | asciilifeform, mod6                                                                                                                         |
   | asciilifeform!asciilifeform, mod6                                                                                                           |
   | asciilifeform, mod6                                                                                                                         |
   | asciilifeform, mod6                                                                                                                         |
   | asciilifeform, mod6                                                                                                                         |
   | asciilifeform!asciilifeform                                                                                                                 |
   | mod6                                                                                                                                        |
  Given expected source files
   | source_files                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
   | a/bitcoin/src/irc.cpp; a/bitcoin/src/protocol.h!a/bitcoin/src/base58.h; a/bitcoin/src/checkpoints.cpp!a/bitcoin/src/irc.h!a/bitcoin/src/bitcoinrpc.cpp; a/bitcoin/src/db.cpp; a/bitcoin/src/headers.h; a/bitcoin/src/init.cpp; a/bitcoin/src/qtui.h; a/bitcoin/src/util.h; a/bitcoin/src/wallet.cpp!a/bitcoin/src/crypter.cpp; a/bitcoin/src/net.h; a/bitcoin/src/protocol.cpp; a/bitcoin/src/script.h; a/bitcoin/src/serialize.h; a/bitcoin/src/uint256.h; a/bitcoin/src/util.cpp!a/bitcoin/src/key.h!a/bitcoin/src/main.cpp; a/bitcoin/src/main.h; a/bitcoin/src/makefile.linux-mingw; a/bitcoin/src/makefile.unix; a/bitcoin/src/net.cpp |
   | a/bitcoin/src/bitcoinrpc.cpp!a/bitcoin/src/headers.h; a/bitcoin/src/util.h!a/bitcoin/src/db.cpp; a/bitcoin/src/init.cpp                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
   | a/bitcoin/src/init.cpp; a/bitcoin/src/makefile.linux-mingw; a/bitcoin/src/makefile.unix!a/bitcoin/src/main.cpp; a/bitcoin/src/main.h!a/bitcoin/src/db.cpp; a/bitcoin/src/net.cpp                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
   | a/bitcoin/src/bitcoinrpc.cpp; a/bitcoin/src/init.cpp; a/bitcoin/src/makefile.linux-mingw!a/bitcoin/src/makefile.unix                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
   | a/bitcoin/src/main.cpp!a/bitcoin/src/main.h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
   | a/bitcoin/src/main.cpp                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
   | a/bitcoin/src/bitcoinrpc.cpp; a/bitcoin/src/util.h!a/bitcoin/src/util.cpp!a/bitcoin/src/net.h; a/bitcoin/src/protocol.cpp!a/bitcoin/src/init.cpp; a/bitcoin/src/net.cpp!a/bitcoin/src/main.h!a/bitcoin/src/db.cpp!a/bitcoin/src/serialize.h                                                                                                                                                                                                                                                                                                                                                                                                 |
   | a/bitcoin/src/main.cpp                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
   | a/bitcoin/src/makefile.unix                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
   | a/bitcoin/src/init.cpp!a/bitcoin/src/net.cpp                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
   | a/bitcoin/src/serialize.h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
   | a/bitcoin/src/net.cpp                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
   | a/bitcoin/src/db.cpp                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
   | a/bitcoin/src/net.cpp                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
   | a/bitcoin/src/bitcoinrpc.cpp!a/bitcoin/src/util.h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
   | a/bitcoin/src/protocol.h!a/bitcoin/src/init.cpp; a/bitcoin/src/irc.cpp; a/bitcoin/src/net.cpp; a/bitcoin/src/net.h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
   | a/bitcoin/src/bitcoinrpc.cpp                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
   | a/bitcoin/src/makefile.unix; a/bitcoin/src/net.h; a/bitcoin/src/serialize.h!a/bitcoin/src/init.cpp                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
   | a/bitcoin/src/bitcoinrpc.cpp                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
   | a/bitcoin/src/bitcoinrpc.cpp; a/bitcoin/src/init.cpp; a/bitcoin/src/util.cpp; a/bitcoin/src/util.h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
   | a/bitcoin/src/init.cpp; a/bitcoin/src/main.cpp; a/bitcoin/src/util.cpp; a/bitcoin/src/util.h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
   | a/bitcoin/src/init.cpp; a/bitcoin/src/util.cpp; a/bitcoin/src/util.h!a/bitcoin/src/main.cpp                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
   | a/bitcoin/src/init.cpp; a/bitcoin/src/util.cpp; a/bitcoin/src/util.h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
  Then validate output descendants

@18 @flowFlag
Scenario: User executes V with the flow flag
  Then validate flow "f" flag output
  Then validate flow "flow" flag output

@19 @graphvizFlag @graphvizFlagWithSvgHtmlOutput
Scenario: User executes V with the graphviz flag with output dot file and SVG html
  Then validate graphviz "g vpatch-graph-test1.dot vpatch-graph-test1.html" flag with output html file
  Then validate graphviz "graph vpatch-graph-test2.dot vpatch-graph-test2.html" flag with output html file

@20 @syncIndividualVpatches
Scenario: User executes V with the sync-vpatches flag
  Then validate sync vpatch "sv http://thebitcoin.foundation testsv_sync1 genesis.vpatch rm_rf_upnp.vpatch" flag output
  Then validate sync vpatch "sync-vpatches http://thebitcoin.foundation testsv_sync2 mod6_fix_dumpblock_params.vpatch bitcoin-v0_5_3-db_config.6.vpatch" flag output
  Then validate sync vpatch "sv" without option argument
  Then validate sync vpatch "sync-vpatches" without option argument

@21 @syncIndividualVpatchesNegTest
Scenario: User executes V with the sync-vpatches flag with non-existant vpatch [Negative Test]
  Then validate sync vpatch fails silently "sv http://thebitcoin.foundation testsv_sync3 xyz.vpatch" with nonexistant vpatch

@22 @syncAllVpatches
Scenario: User executes V with the sync-all-vpatches flag
  Then validate sync all flag for "26" vpatches with options "sa http://thebitcoin.foundation testvpsync1"
  Then validate sync all flag for "26" vpatches with options "sync-all-vpatches http://thebitcoin.foundation testvpsync2"
  Then validate sync all vpatches "sa" without option argument
  Then validate sync all vpatches "sync-all-vpatches" without option argument

@23 @syncSealsFlag
Scenario: User executes V with the sync-seals flag
  Then validate sync seals flag for "51" seals with options "ss http://thebitcoin.foundation testsealsync1"
  Then validate sync seals flag for "51" seals with options "sync-seals http://thebitcoin.foundation testsealsync2"
  Then validate sync seals "ss" without option argument
  Then validate sync seals "sync-seals" without option argument

@24 @syncEverythingFlag
Scenario: User executes V with the sync-everthing flag
  Then validate sync everything flag for "26" vpatches "51" seals with options "se http://thebitcoin.foundation testse_vpatch_1 testse_seals_1"
  Then validate sync everything flag for "26" vpatches "51" seals with options "sync-everything http://thebitcoin.foundation testse_vpatch_2 testse_seals_2"
  Then validate sync everything "se" without option argument
  Then validate sync everything "sync-everything" without option argument

@25 @testWildVpatch @patchDirFlag
Scenario: User introduces a new unsigned WILD patch & executes V with patchdir flag - Depends upon scenario @16 @syncAllVpatches
  When add a test patch to the new patchdir "testvpsync1"
  Then point v at patch dir "testvpsync1" with flag "pd" and validate
  Then point v at patch dir "testvpsync1" with flag "patchdir" and validate

@26 @sealDirFlag
Scenario: User executes V with the sealdir flag - Depends upon scneario @17 @syncSealsFlag
  When point v at seals dir "testsealsync1" and delete all seals from "mod6"
  Then point v at seals dir "testsealsync1" with flag "sd" and validate no vpatches with seals by "mod6"
  Then point v at seals dir "testsealsync1" with flag "sealdir" and validate no vpatches with seals by "mod6"

@27 @pressFlag
Scenario: User executes V with the press flag
  Then validate press "p" to dir "press1" with head "genesis.vpatch" 
  Then validate press "p" to dir "press2" with head "asciilifeform_maxint_locks_corrected.vpatch" 
  Then validate press "p" to dir "press3" with head "asciilifeform_add_verifyall_option.vpatch" 
  Then I remove "press1"
  Then I remove "press2"
  Then I remove "press3"

@28 @pressFlag
Scenario: Execute with press command with an output directory that begins with the letter 'v'.
  Then validate press "p" to dir "v054" with head "asciilifeform_add_verifyall_option.vpatch"
  Then I remove "v054"

@29 @sealTest
Scenario: Make a copy of WoT dir and reduce to one wot id, then ensure that V dies when encountering a seal that doesn't match a WoT entry.
  When user creates new wot directory "wot3" with one entry "mod6.asc"
  When user creates new seals directory "seals3" with one entry from a nonexisting WoT member "asciilifeform_add_verifyall_option.vpatch.asciilifeform.sig"
  Then I validate that V will fail when encountering a seal in "seals3" from an entity not in the current WoT "wot3"

@30 @cleanup
Scenario: Cleanup test files and directories
  Then I remove "testvpsync1"
  Then I remove "testvpsync2"
  Then I remove "testsealsync1"
  Then I remove "testsealsync2"
  Then I remove "testsv_sync1"
  Then I remove "testsv_sync2"
  Then I remove "testsv_sync3"
  Then I remove "testse_vpatch_1"
  Then I remove "testse_vpatch_2"
  Then I remove "testse_seals_1"
  Then I remove "testse_seals_2"
  Then I remove "vpatch-graph-test1.dot"
  Then I remove "vpatch-graph-test1.html"
  Then I remove "vpatch-graph-test2.dot"
  Then I remove "vpatch-graph-test2.html"
  Then I remove "wot3"
  Then I remove "seals3"
  Then I remove ".seals"
  Then I remove "~/.gnupgtmp"
  Then I remove "patches"
  Then I remove "mirror"
  Then I remove "logs"
